<?php
require_once __DIR__ . '/config.php';
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/auth.php';
require_once __DIR__ . '/utils.php';

function h($s){ return htmlspecialchars($s ?? '', ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); }
function is_admin(){
    return isset($_SESSION['user']) && isset($_SESSION['user']['login']) && in_array($_SESSION['user']['login'], ADMIN_LOGINS, true);
}

// Handle comment deletion in admin panel
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'delete_comment_admin' && is_admin()) {
    $comment_id = intval($_POST['comment_id']);
    
    if ($comment_id > 0) {
        $stmt = $db->prepare("DELETE FROM comments WHERE id = ?");
        $stmt->execute([$comment_id]);
    }
    
    // Redirect back to the comments tab
    header('Location: admin.php#comments-tab');
    exit;
}

// Check if we're editing an existing post
$edit_post_id = isset($_GET['edit']) ? intval($_GET['edit']) : null;
$edit_post = null;
if ($edit_post_id && $edit_post_id != 1) {
    $stmt = $db->prepare("SELECT * FROM posts WHERE id = ?");
    $stmt->execute([$edit_post_id]);
    $edit_post = $stmt->fetch();
    
    if (!$edit_post) {
        die('Post not found');
    }
}

// Determine which tab is active
// If we have an edit parameter (and it's not the placeholder '1'), we're editing a specific post
// If we have edit=1, we're on the edit tab but not editing a specific post yet
$active_tab = (isset($_GET['edit'])) ? 'edit' : 'add';

// Get existing attachments for the post if editing
$existing_attachments = [];
if ($edit_post_id && $edit_post_id != 1) {
    // Try to get attachments with sort_order, fallback to uploaded_at if sort_order doesn't exist
    try {
        $att_stmt = $db->prepare("SELECT * FROM attachments WHERE post_id = ? ORDER BY sort_order, uploaded_at");
        $att_stmt->execute([$edit_post_id]);
    } catch (PDOException $e) {
        // If sort_order column doesn't exist, fallback to uploaded_at
        if (strpos($e->getMessage(), 'sort_order') !== false) {
            $att_stmt = $db->prepare("SELECT * FROM attachments WHERE post_id = ? ORDER BY uploaded_at");
            $att_stmt->execute([$edit_post_id]);
        } else {
            throw $e;
        }
    }
    $existing_attachments = $att_stmt->fetchAll();
}
?>
<!DOCTYPE html>
<html lang="ru">
<head>
<meta charset="utf-8">
<title>Архив.ДуДу2</title>
<!-- Summernote lite (Bootstrap-free) -->
<link href="https://cdn.jsdelivr.net/npm/summernote@0.8.20/dist/summernote-lite.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/jquery@3.7.1/dist/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/summernote@0.8.20/dist/summernote-lite.min.js"></script>
<style>
/* Centered container styles */
.container-wrapper {
  display: flex;
  justify-content: center;
  align-items: flex-start;
  min-height: 100vh;
  padding: 20px;
  background-color: #f0f0f0;
  font-family: Verdana, Arial, sans-serif;
}

.main-container {
  width: 100%;
  max-width: 1200px;
  background-color: white;
  border: 1px solid #ccc;
  box-shadow: 0 0 10px rgba(0,0,0,0.1);
}

.header {
  background: linear-gradient(to bottom, #0099cc, #007790, #005a70);
  color: white;
  padding: 10px 15px;
  display: flex;
  justify-content: space-between;
  align-items: center;
  border-bottom: 1px solid #ccc;
}

.header-title {
  font-size: 18px;
  font-weight: bold;
}

.user-info {
  font-size: 12px;
}

.user-info a {
  color: white;
  text-decoration: none;
}

.user-info a:hover {
  text-decoration: underline;
}

.content-wrapper {
  display: flex;
  padding: 0;
}

.sidebar {
  width: 220px;
  background-color: #f5f5f5;
  border-right: 1px solid #ddd;
  padding: 15px;
}

.sidebar-section {
  margin-bottom: 20px;
}

.sidebar-title {
  background: linear-gradient(to bottom, #0099cc, #007790, #005a70);
  color: white;
  padding: 5px 8px;
  font-size: 12px;
  font-weight: bold;
  margin-bottom: 10px;
  border: 1px solid #005a70;
}

.sidebar-link {
  display: block;
  color: #0000cc;
  text-decoration: none;
  font-size: 12px;
  margin-bottom: 5px;
  padding: 2px 0;
}

.sidebar-link:hover {
  text-decoration: underline;
}

.search-form input[type="text"] {
  width: 100%;
  padding: 3px;
  font-size: 12px;
  margin-bottom: 5px;
  border: 1px solid #999;
}

.search-form input[type="submit"] {
  font-size: 12px;
  padding: 2px 8px;
  background-color: #007790;
  color: white;
  border: 1px solid #005a70;
  cursor: pointer;
}

.search-form input[type="submit"]:hover {
  background-color: #005a70;
}

.categories-list {
  font-size: 12px;
}

.categories-list a {
  color: #0000cc;
  text-decoration: none;
}

.categories-list a:hover {
  text-decoration: underline;
}

.main-content {
  flex: 1;
  padding: 15px;
}

/* Form styling */
.form-table {
  width: 100%;
  border-collapse: collapse;
}

.form-table td {
  padding: 4px;
  vertical-align: top;
}

.form-table input[type="text"], 
.form-table select {
  width: 100%;
  padding: 3px;
  font-family: Verdana;
  font-size: 12px;
  border: 1px solid #999;
}

.form-table textarea {
  width: 100%;
  font-family: Verdana;
  font-size: 12px;
  border: 1px solid #999;
}

.form-table input[type="submit"] {
  background-color: #007790;
  color: white;
  border: 1px solid #005a70;
  padding: 4px 10px;
  font-family: Verdana;
  font-size: 12px;
  cursor: pointer;
}

.form-table input[type="submit"]:hover {
  background-color: #005a70;
}

/* Tab styling */
.tab {
  display: inline-block;
  padding: 10px 20px;
  cursor: pointer;
  border: 1px solid #007790;
  border-bottom: none;
  margin-right: 5px;
  background: linear-gradient(to bottom, #e5eef7, #d0ddee);
  font-family: Verdana;
  font-size: 14px;
  color: #000;
}
.tab.active {
  background: linear-gradient(to bottom, #0099cc, #007790, #005a70);
  color: white;
  font-weight: bold;
}
.tab-content {
  display: none;
  border: 1px solid #007790;
  padding: 20px;
  margin-top: 0;
}
.tab-content.active {
  display: block;
}
.post-list {
  max-height: 400px;
  overflow-y: auto;
  border: 1px solid #ccc;
  padding: 10px;
  margin-top: 10px;
}
.post-item {
  padding: 10px;
  border-bottom: 1px solid #eee;
  display: flex;
  justify-content: space-between;
  align-items: center;
}
.post-item:hover {
  background-color: #f0f0f0;
}
.edit-btn {
  background: linear-gradient(to bottom, #0099cc, #007790, #005a70);
  color: white;
  border: 1px solid #005a70;
  padding: 5px 10px;
  cursor: pointer;
  font-family: Verdana;
  font-size: 12px;
}
.edit-btn:hover {
  background: linear-gradient(to bottom, #007790, #005a70, #003d50);
}
.upload-area {
  border: 2px dashed #ccc;
  padding: 20px;
  text-align: center;
  margin-bottom: 10px;
  cursor: pointer;
  background-color: #f9f9f9;
}
.upload-area:hover {
  border-color: #007790;
  background-color: #f0f8ff;
}
.upload-area.dragover {
  border-color: #007790;
  background-color: #e0f0ff;
}
.progress-container {
  margin: 10px 0;
}
.progress-bar {
  width: 100%;
  height: 20px;
  background-color: #f0f0f0;
  border: 1px solid #999;
  border-radius: 3px;
  overflow: hidden;
}
.progress-fill {
  height: 100%;
  background: linear-gradient(to bottom, #0099cc, #007790);
  width: 0%;
  transition: width 0.3s;
}
.file-item {
  padding: 5px;
  border-bottom: 1px solid #eee;
  display: flex;
  justify-content: space-between;
  align-items: center;
}
.file-item .remove-btn {
  color: red;
  cursor: pointer;
  font-weight: bold;
}
.existing-attachments {
  margin-top: 15px;
  padding-top: 15px;
  border-top: 1px solid #eee;
}
.sortable-files {
  min-height: 40px;
  border: 1px dashed #ddd;
  padding: 10px;
  margin-top: 10px;
  background-color: #fafafa;
}
.sortable-files .file-item {
  cursor: move;
  user-select: none;
}
.sortable-files .file-item.dragging {
  opacity: 0.5;
  background-color: #e0f0ff;
}
.pagination {
  margin-top: 15px;
  text-align: center;
}
.pagination a, .pagination b {
  padding: 5px 10px;
  margin: 0 2px;
  text-decoration: none;
  border: 1px solid #007790;
  color: #007790;
  background-color: #e5eef7;
}
.pagination b {
  background: linear-gradient(to bottom, #0099cc, #007790, #005a70);
  color: white;
  font-weight: bold;
}
.sort-options {
  margin-bottom: 15px;
}
.sort-options a {
  text-decoration: none;
  color: #007790;
}
.sort-options a:hover {
  text-decoration: underline;
}
.sort-options a.active {
  font-weight: bold;
  text-decoration: underline;
}

.footer {
  background-color: #f0f0f0;
  padding: 10px 15px;
  text-align: right;
  border-top: 1px solid #ddd;
  font-size: 11px;
  color: #666;
}

/* Summernote editor styling */
.note-editor {
  border: 1px solid #999;
}

.note-toolbar {
  border-bottom: 1px solid #999;
  background-color: #f5f5f5;


</style>
<script>
// Initialize Summernote editors when the page loads
$(document).ready(function() {
  $('#editor-add').summernote({
    height: 200,
    toolbar: [
      ['style', ['bold', 'italic', 'underline', 'clear']],
      ['font', ['strikethrough']],
      ['para', ['ul', 'ol', 'paragraph']],
      ['table', ['table']],
      ['insert', ['link', 'picture']],
      ['view', ['fullscreen', 'codeview', 'help']]
    ]
  });
  
  $('#editor-edit').summernote({
    height: 200,
    toolbar: [
      ['style', ['bold', 'italic', 'underline', 'clear']],
      ['font', ['strikethrough']],
      ['para', ['ul', 'ol', 'paragraph']],
      ['table', ['table']],
      ['insert', ['link', 'picture']],
      ['view', ['fullscreen', 'codeview', 'help']]
    ]
  });
});
</script>
</head>
<body>
<div class="container-wrapper">
  <div class="main-container">
    <div class="header">
      <div class="header-title">Архив.ДуДу2</div>
      <div class="user-info">
        <?php if(isset($_SESSION['user'])): ?>
          Пользователь: <b><?php echo h($_SESSION['user']['name'] ?? $_SESSION['user']['login']); ?></b> |
          <?php if(is_admin()): ?><a href="admin.php">Админ панель</a> |<?php endif; ?>
          <a href="index.php?action=logout">Выход</a>
        <?php else: ?>
          <a href="<?php echo h(AUTH_LOGIN_URL . '&redirect_uri=' . urlencode(SITE_URL)); ?>">Войти</a>
        <?php endif; ?>
      </div>
    </div>

    <div class="content-wrapper">
      <div class="sidebar">
        <div class="sidebar-section">
          <div class="sidebar-title">Навигация</div>
          <a href="index.php" class="sidebar-link">Последние записи</a>
          <a href="browse.php" class="sidebar-link">Все категории</a>
          <?php if(is_admin()): ?><a href="admin.php" class="sidebar-link">Админ панель</a><?php endif; ?>
        </div>
        
        <div class="sidebar-section">
          <div class="sidebar-title">Поиск</div>
          <form action="search.php" method="get" class="search-form">
            <div style="display: flex;">
              <input type="text" name="q" size="15" style="flex: 1; margin-right: 5px;">
              <input type="submit" value="Найти" style="flex: 0 0 auto; padding: 3px 8px;">
            </div>
          </form>
        </div>
        
        <div class="sidebar-section">
          <div class="sidebar-title">Категории</div>
          <div class="categories-list">
            <?php
            $cats = $db->query("SELECT id, name, slug, (SELECT COUNT(*) FROM posts p WHERE p.category_id=c.id) as cnt FROM categories c ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);
            if($cats){
                foreach($cats as $c){
                    echo '<a href="browse.php?cat='.h($c['slug']).'">'.h($c['name']).'</a> ('.intval($c['cnt']).')<br>';
                }
            } else {
                echo 'Нет категорий';
            }
            ?>
          </div>
        </div>
      </div>
      
      <div class="main-content">
<?php
if(!is_admin()){
    echo '<font face=Verdana size=-1>Доступ запрещен.</font>';
} else {
    $cats = getCategoriesWithCount($db);
    $tags = getAllTags($db);
    
    // Get existing tags for the post if editing
    $existing_tags = '';
    if ($edit_post) {
        $tag_stmt = $db->prepare("SELECT t.name FROM tags t INNER JOIN post_tags pt ON pt.tag_id=t.id WHERE pt.post_id=? ORDER BY t.name");
        $tag_stmt->execute([$edit_post_id]);
        $existing_tags_arr = $tag_stmt->fetchAll(PDO::FETCH_COLUMN);
        $existing_tags = implode(', ', $existing_tags_arr);
    }
    

?>
<!-- Virtual Tabs -->
<div>
  <div class="tab <?php echo $active_tab === 'add' ? 'active' : ''; ?>" onclick="showTab('add')">Добавить новую запись</div>
  <div class="tab <?php echo $active_tab === 'edit' ? 'active' : ''; ?>" onclick="showTab('edit')">Редактировать существующую</div>
  <div class="tab <?php echo $active_tab === 'comments' ? 'active' : ''; ?>" onclick="showTab('comments')">Комментарии</div>
  <div style="clear: both;"></div>
  
  <!-- Add New Post Tab -->
  <div id="add-tab" class="tab-content <?php echo $active_tab === 'add' ? 'active' : ''; ?>">
    <font face="Verdana" size="+0"><b>Добавить новую запись</b></font><br><br>
    <form action="save_post.php" method="post" onsubmit="return beforeSubmit();">
    <input type="hidden" name="post_id" value="">
    <table class="form-table">
    <tr><td width="160"><font face="Verdana" size="-1">Заголовок:</font></td><td><input type="text" name="title" size="80" required></td></tr>
    <tr><td><font face="Verdana" size="-1">Категория:</font></td><td>
    <select name="category_id">
    <option value="">— выбрать —</option>
    <?php 
    foreach($cats as $c){ 
        echo '<option value="'.intval($c['id']).'">'.h($c['name']).'</option>'; 
    } 
    ?>
    </select>
    &nbsp;или новая: <input type="text" name="new_category" size="30">
    </td></tr>
    <tr><td><font face="Verdana" size="-1">Теги:</font></td><td>
    <input type="text" name="tags" size="80" placeholder="через запятую">
    <br><font face="Verdana" size="-2">Существующие: <?php echo h(implode(', ', $tags)); ?></font>
    </td></tr>
    <tr><td valign="top"><font face="Verdana" size="-1">Текст:</font></td><td>
    <div id="editor-add" style="border:1px solid #999; min-height:200px;"></div>
    <input type="hidden" name="content_html" id="content_html_add">
    </td></tr>

    <tr><td valign="top"><font face="Verdana" size="-1">Вложения:</font></td><td>
    <div class="upload-area" id="upload-area-add">
      <p>Перетащите файлы сюда или нажмите для выбора</p>
      <input type="file" id="files-add" multiple style="display: none;">
    </div>
    <div id="progress-container-add" class="progress-container" style="display: none;">
      <div class="progress-bar">
        <div class="progress-fill" id="progress-fill-add"></div>
      </div>
      <div id="progress-text-add">Загрузка: 0%</div>
    </div>
    <div id="uploads-add" class="sortable-files"></div>
    <input type="hidden" name="uploaded_files" id="uploaded_files_add" value="[]">
    </td></tr>

    <tr><td></td><td><input type="submit" value="Сохранить запись"></td></tr>
    </table>
    </form>
  </div>
  
  <!-- Edit Existing Post Tab -->
  <div id="edit-tab" class="tab-content <?php echo $active_tab === 'edit' ? 'active' : ''; ?>">
    <font face="Verdana" size="+0"><b>Редактировать существующую запись</b></font><br><br>
    
    <!-- Sorting and Pagination Controls -->
    <div class="sort-options">
      <font face="Verdana" size="-1">
        Сортировать по: 
        <a href="admin.php?edit=<?php echo $edit_post_id && $edit_post_id != 1 ? $edit_post_id : '1'; ?>&sort=date&page=<?php echo $page; ?>" class="<?php echo (!isset($_GET['sort']) || $_GET['sort'] == 'date') ? 'active' : ''; ?>">дате добавления</a> | 
        <a href="admin.php?edit=<?php echo $edit_post_id && $edit_post_id != 1 ? $edit_post_id : '1'; ?>&sort=title&page=<?php echo $page; ?>" class="<?php echo (isset($_GET['sort']) && $_GET['sort'] == 'title') ? 'active' : ''; ?>">алфавиту</a>
      </font>
    </div>
    
    <?php
    // Determine sorting
    $sort = isset($_GET['sort']) ? $_GET['sort'] : 'date';
    $sort_column = ($sort == 'title') ? 'title' : 'created_at';
    $sort_direction = ($sort == 'title') ? 'ASC' : 'DESC';
    
    // Pagination
    $page = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
    $per_page = 6;
    $offset = ($page - 1) * $per_page;
    
    // Get total count with limit to prevent counting all rows unnecessarily
    $total_stmt = $db->query("SELECT COUNT(*) as count FROM posts");
    $total_row = $total_stmt->fetch();
    $total_posts = $total_row['count'];
    $total_pages = min(ceil($total_posts / $per_page), 100); // Limit to 100 pages max
    
    // Get posts for current page with limit
    $posts_stmt = $db->prepare("SELECT id, title, created_at FROM posts ORDER BY {$sort_column} {$sort_direction} LIMIT :limit OFFSET :offset");
    $posts_stmt->bindValue(':limit', $per_page, PDO::PARAM_INT);
    $posts_stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
    $posts_stmt->execute();
    $all_posts = $posts_stmt->fetchAll();
    ?>
    
    <!-- Post List -->
    <div class="post-list">
      <?php if (!empty($all_posts)): ?>
        <?php foreach ($all_posts as $post): ?>
          <div class="post-item">
            <div>
              <strong><?php echo h($post['title']); ?></strong><br>
              <small>Дата: <?php echo h($post['created_at']); ?></small>
            </div>
            <button class="edit-btn" onclick="editPost(<?php echo intval($post['id']); ?>)">Редактировать</button>
          </div>
        <?php endforeach; ?>
      <?php else: ?>
        <p>Нет записей для редактирования.</p>
      <?php endif; ?>
    </div>
    
    <!-- Pagination -->
    <?php if ($total_pages > 1): ?>
    <div class="pagination">
      <font face="Verdana" size="-1">
        <?php for ($i = 1; $i <= $total_pages; $i++): ?>
          <?php if ($i == $page): ?>
            <b>[<?php echo $i; ?>]</b>
          <?php else: ?>
            <a href="admin.php?edit=<?php echo $edit_post_id && $edit_post_id != 1 ? $edit_post_id : '1'; ?>&sort=<?php echo h($sort); ?>&page=<?php echo $i; ?>">[<?php echo $i; ?>]</a>
          <?php endif; ?>
        <?php endfor; ?>
      </font>
    </div>
    <?php endif; ?>
    
    <div id="edit-form-container" style="display: <?php echo ($edit_post_id && $edit_post_id != 1) ? 'block' : 'none'; ?>;">
    <?php if ($edit_post_id && $edit_post_id != 1): ?>
    <br>
    <form action="save_post.php" method="post" onsubmit="return beforeSubmitEdit();">
    <input type="hidden" name="post_id" value="<?php echo $edit_post ? $edit_post['id'] : ''; ?>">
    <table class="form-table">
    <tr><td width="160"><font face="Verdana" size="-1">Заголовок:</font></td><td><input type="text" name="title" size="80" value="<?php echo $edit_post ? h($edit_post['title']) : ''; ?>" required></td></tr>
    <tr><td><font face="Verdana" size="-1">Категория:</font></td><td>
    <select name="category_id">
    <option value="">— выбрать —</option>
    <?php 
    foreach($cats as $c){ 
        $selected = ($edit_post && $edit_post['category_id'] == $c['id']) ? 'selected' : '';
        echo '<option value="'.intval($c['id']).'" '.$selected.'>'.h($c['name']).'</option>'; 
    } 
    ?>
    </select>
    &nbsp;или новая: <input type="text" name="new_category" size="30">
    </td></tr>
    <tr><td><font face="Verdana" size="-1">Теги:</font></td><td>
    <input type="text" name="tags" size="80" value="<?php echo h($existing_tags); ?>" placeholder="через запятую">
    <br><font face="Verdana" size="-2">Существующие: <?php echo h(implode(', ', $tags)); ?></font>
    </td></tr>
    <tr><td valign="top"><font face="Verdana" size="-1">Текст:</font></td><td>
    <div id="editor-edit" style="border:1px solid #999; min-height:200px;"><?php echo $edit_post ? $edit_post['content_html'] : ''; ?></div>
    <input type="hidden" name="content_html" id="content_html_edit">
    </td></tr>

    <tr><td valign="top"><font face="Verdana" size="-1">Вложения:</font></td><td>
    <?php if (!empty($existing_attachments)): ?>
    <div class="existing-attachments">
      <font face="Verdana" size="-1"><b>Существующие вложения:</b></font>
      <div class="sortable-files" id="existing-files">
        <?php foreach ($existing_attachments as $attachment): ?>
          <div class="file-item" data-id="<?php echo $attachment['id']; ?>">
            <span><?php echo h($attachment['original_name']); ?> (<?php echo number_format($attachment['size']/1024, 1, ',', ' '); ?> КБ)</span>
            <span class="remove-btn" onclick="removeAttachment(<?php echo $attachment['id']; ?>)">✕</span>
          </div>
        <?php endforeach; ?>
      </div>
    </div>
    <?php endif; ?>
    
    <div class="upload-area" id="upload-area-edit">
      <p>Перетащите файлы сюда или нажмите для выбора</p>
      <input type="file" id="files-edit" multiple style="display: none;">
    </div>
    <div id="progress-container-edit" class="progress-container" style="display: none;">
      <div class="progress-bar">
        <div class="progress-fill" id="progress-fill-edit"></div>
      </div>
      <div id="progress-text-edit">Загрузка: 0%</div>
    </div>
    <div id="uploads-edit" class="sortable-files"></div>
    <input type="hidden" name="uploaded_files" id="uploaded_files_edit" value="[]">
    </td></tr>

    <tr><td></td><td><input type="submit" value="Сохранить изменения"></td></tr>
    </table>
    </form>
    <?php endif; ?>
    </div>
  </div>
  
  <!-- Comments Tab -->
  <div id="comments-tab" class="tab-content <?php echo $active_tab === 'comments' ? 'active' : ''; ?>">
    <font face="Verdana" size="+0"><b>Управление комментариями</b></font><br><br>
    
    <?php
    // Get recent comments with post information
    $comments_stmt = $db->prepare("SELECT c.*, p.title as post_title, p.slug as post_slug FROM comments c LEFT JOIN posts p ON c.post_id = p.id ORDER BY c.created_at DESC LIMIT 50");
    $comments_stmt->execute();
    $comments = $comments_stmt->fetchAll();
    
    if ($comments):
    ?>
    <div class="comments-container" style="border: 1px solid #ccc; border-radius: 5px; padding: 15px; background-color: #f9f9f9;">
      <?php foreach ($comments as $index => $comment): ?>
        <?php if ($index > 0): ?>
          <div style="border-top: 1px solid #ddd; margin: 15px 0;"></div>
        <?php endif; ?>
        
        <div class="comment-item" style="margin-bottom: 15px; padding: 10px; background-color: white; border: 1px solid #eee; border-radius: 3px;">
          <div class="comment-header" style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 10px; padding-bottom: 8px; border-bottom: 1px solid #eee;">
            <div class="comment-author" style="font-weight: bold; color: #007790;">
              <?php echo h($comment['user_name']); ?>
            </div>
            <div class="comment-date" style="font-size: 11px; color: #666;">
              <?php echo h($comment['created_at']); ?>
            </div>
          </div>
          
          <div class="comment-content" style="margin-bottom: 10px; font-size: 12px; line-height: 1.4;">
            <?php echo nl2br(h($comment['content'])); ?>
          </div>
          
          <div class="comment-post" style="margin-bottom: 10px; font-size: 11px;">
            <strong>Запись:</strong> 
            <?php if ($comment['post_title']): ?>
              <a href="post.php?slug=<?php echo h($comment['post_slug']); ?>" target="_blank" style="color: #0000cc; text-decoration: none;">
                <?php echo h($comment['post_title']); ?>
              </a>
            <?php else: ?>
              <span style="color: #999;">Удалена запись</span>
            <?php endif; ?>
          </div>
          
          <div class="comment-actions" style="text-align: right;">
            <button type="button" onclick="editComment(<?php echo $comment['id']; ?>)" 
                    style="font-size: 12px; padding: 2px 8px; background-color: #007790; color: white; border: 1px solid #005a70; cursor: pointer; border-radius: 3px; margin-right: 5px;">
              Редактировать
            </button>
            <form method="post" style="display: inline;" onsubmit="return confirm('Вы уверены, что хотите удалить этот комментарий?');">
              <input type="hidden" name="action" value="delete_comment_admin">
              <input type="hidden" name="comment_id" value="<?php echo $comment['id']; ?>">
              <input type="submit" value="Удалить" 
                     style="font-size: 12px; padding: 2px 8px; background-color: #cc0000; color: white; border: 1px solid #990000; cursor: pointer; border-radius: 3px;">
            </form>
          </div>
        </div>
      <?php endforeach; ?>
    </div>
    <?php else: ?>
      <div style="padding: 20px; text-align: center; background-color: #f9f9f9; border: 1px solid #ddd; border-radius: 5px;">
        <p style="margin: 0; color: #666;">Нет комментариев для отображения.</p>
      </div>
    <?php endif; ?>
  </div>
</div>

<script>
// JavaScript functions for the admin interface
function showTab(tabName) {
  // Hide all tab contents
  document.getElementById('add-tab').classList.remove('active');
  document.getElementById('edit-tab').classList.remove('active');
  document.getElementById('comments-tab').classList.remove('active');
  
  // Remove active class from all tabs
  var tabs = document.querySelectorAll('.tab');
  tabs.forEach(function(tab) {
    tab.classList.remove('active');
  });
  
  // Show the selected tab content
  document.getElementById(tabName + '-tab').classList.add('active');
  
  // Add active class to the clicked tab
  event.currentTarget.classList.add('active');
  
  // Update the URL to reflect the active tab without page reload
  var url = new URL(window.location);
  if (tabName === 'edit') {
    url.searchParams.set('edit', '1');
  } else {
    url.searchParams.delete('edit');
  }
  window.history.replaceState({}, '', url);
}

function editPost(postId) {
  // Update the URL to edit the specific post
  var url = new URL(window.location);
  url.searchParams.set('edit', postId);
  url.searchParams.set('sort', '<?php echo h($sort); ?>');
  url.searchParams.set('page', '<?php echo $page; ?>');
  window.location.href = url;
}

function removeAttachment(attachmentId) {
  // Send AJAX request to delete the attachment without confirmation
  fetch('delete_attachment.php', {
    method: 'POST',
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
    },
    body: 'attachment_id=' + attachmentId
  })
  .then(response => response.json())
  .then(data => {
    if (data.ok) {
      // Remove the attachment from the DOM
      var attachmentElement = document.querySelector('.file-item[data-id="' + attachmentId + '"]');
      if (attachmentElement) {
        attachmentElement.remove();
      }
    } else {
      alert('Ошибка при удалении вложения: ' + data.message);
    }
  })
  .catch(error => {
    console.error('Error:', error);
    alert('Ошибка при удалении вложения.');
  });
}

function beforeSubmit() {
  // Get the HTML content from Summernote editor
  var content = $('#editor-add').summernote('code');
  document.getElementById('content_html_add').value = content;
  
  // Collect the order of uploaded attachments
  var uploadsContainer = document.getElementById('uploads-add');
  if (uploadsContainer) {
    var fileItems = uploadsContainer.querySelectorAll('.file-item');
    
    // Update the sort_order in the uploaded_files JSON
    var uploadedFilesInput = document.getElementById('uploaded_files_add');
    var uploadedFiles = JSON.parse(uploadedFilesInput.value || '[]');
    
    // Update the sort_order for each file based on their current order in the DOM
    fileItems.forEach(function(item, index) {
      // Find the corresponding file in uploadedFiles by matching the original_name
      for (var i = 0; i < uploadedFiles.length; i++) {
        // Extract original name from the DOM element
        var spanText = item.querySelector('span').textContent;
        var originalName = spanText.substring(0, spanText.lastIndexOf(' ('));
        
        if (uploadedFiles[i].original_name === originalName) {
          uploadedFiles[i].sort_order = index;
          break;
        }
      }
    });
    
    // Update the hidden input
    uploadedFilesInput.value = JSON.stringify(uploadedFiles);
  }
  
  // Debug: Log the uploaded files data
  console.log('Uploaded files data:', document.getElementById('uploaded_files_add').value);
  
  // Continue with form submission
  return true;
}

function beforeSubmitEdit() {
  // Get the HTML content from Summernote editor
  var content = $('#editor-edit').summernote('code');
  document.getElementById('content_html_edit').value = content;
  
  // Collect the order of existing attachments
  var existingFilesContainer = document.getElementById('existing-files');
  if (existingFilesContainer) {
    var attachmentOrder = [];
    var fileItems = existingFilesContainer.querySelectorAll('.file-item');
    
    fileItems.forEach(function(item, index) {
      var attachmentId = item.getAttribute('data-id');
      if (attachmentId) {
        attachmentOrder.push({
          id: parseInt(attachmentId),
          sort_order: index
        });
      }
    });
    
    // Add the attachment order to the form
    var attachmentOrderInput = document.createElement('input');
    attachmentOrderInput.type = 'hidden';
    attachmentOrderInput.name = 'existing_attachments_order';
    attachmentOrderInput.value = JSON.stringify(attachmentOrder);
    
    // Add to the form
    var form = document.querySelector('#edit-tab form');
    form.appendChild(attachmentOrderInput);
  }
  
  // Continue with form submission
  return true;
}

// File upload handling
// Add debugging
console.log('Setting up file upload event handlers');

// Check if elements exist before attaching handlers
document.addEventListener('DOMContentLoaded', function() {
  console.log('DOM loaded, setting up event handlers');
  
  var uploadAreaAdd = document.getElementById('upload-area-add');
  var filesAdd = document.getElementById('files-add');
  var uploadAreaEdit = document.getElementById('upload-area-edit');
  var filesEdit = document.getElementById('files-edit');
  
  if (uploadAreaAdd && filesAdd) {
    console.log('Attaching click handler to upload-area-add');
    uploadAreaAdd.addEventListener('click', function() {
      console.log('Upload area add clicked');
      filesAdd.click();
    });
  } else {
    console.log('upload-area-add or files-add not found');
  }
  
  if (uploadAreaEdit && filesEdit) {
    console.log('Attaching click handler to upload-area-edit');
    uploadAreaEdit.addEventListener('click', function() {
      console.log('Upload area edit clicked');
      filesEdit.click();
    });
  } else {
    console.log('upload-area-edit or files-edit not found');
  }
  
  if (filesAdd) {
    console.log('Attaching change handler to files-add');
    filesAdd.addEventListener('change', function(e) {
      console.log('Files selected for add:', e.target.files.length);
      handleFileUpload(e.target.files, 'add');
    });
  } else {
    console.log('files-add not found');
  }
  
  if (filesEdit) {
    console.log('Attaching change handler to files-edit');
    filesEdit.addEventListener('change', function(e) {
      console.log('Files selected for edit:', e.target.files.length);
      handleFileUpload(e.target.files, 'edit');
    });
  } else {
    console.log('files-edit not found');
  }
});

// Drag and drop handling
['dragenter', 'dragover', 'dragleave', 'drop'].forEach(eventName => {
  document.getElementById('upload-area-add').addEventListener(eventName, preventDefaults, false);
  document.getElementById('upload-area-edit').addEventListener(eventName, preventDefaults, false);
});

function preventDefaults(e) {
  e.preventDefault();
  e.stopPropagation();
}

['dragenter', 'dragover'].forEach(eventName => {
  document.getElementById('upload-area-add').addEventListener(eventName, highlightAdd, false);
  document.getElementById('upload-area-edit').addEventListener(eventName, highlightEdit, false);
});

['dragleave', 'drop'].forEach(eventName => {
  document.getElementById('upload-area-add').addEventListener(eventName, unhighlightAdd, false);
  document.getElementById('upload-area-edit').addEventListener(eventName, unhighlightEdit, false);
});

function highlightAdd() {
  document.getElementById('upload-area-add').classList.add('dragover');
}

function unhighlightAdd() {
  document.getElementById('upload-area-add').classList.remove('dragover');
}

function highlightEdit() {
  document.getElementById('upload-area-edit').classList.add('dragover');
}

function unhighlightEdit() {
  document.getElementById('upload-area-edit').classList.remove('dragover');
}

document.getElementById('upload-area-add').addEventListener('drop', handleDropAdd, false);
document.getElementById('upload-area-edit').addEventListener('drop', handleDropEdit, false);

function handleDropAdd(e) {
  let dt = e.dataTransfer;
  let files = dt.files;
  handleFileUpload(files, 'add');
}

function handleDropEdit(e) {
  let dt = e.dataTransfer;
  let files = dt.files;
  handleFileUpload(files, 'edit');
}

function handleFileUpload(files, context) {
  console.log('handleFileUpload called with ' + files.length + ' files for context: ' + context);
  
  // Show progress container
  var progressContainer = document.getElementById('progress-container-' + context);
  var progressFill = document.getElementById('progress-fill-' + context);
  var progressText = document.getElementById('progress-text-' + context);
  
  if (!progressContainer || !progressFill || !progressText) {
    console.error('Progress elements not found for context: ' + context);
    return;
  }
  
  progressContainer.style.display = 'block';
  
  // Get existing uploaded files
  var uploadedFilesInput = document.getElementById('uploaded_files_' + context);
  var uploadedFiles = JSON.parse(uploadedFilesInput.value || '[]');
  
  // Upload each file
  for (let i = 0; i < files.length; i++) {
    let file = files[i];
    console.log('Processing file: ' + file.name);
    
    // Create FormData for the file
    var formData = new FormData();
    formData.append('file', file);
    
    // Create XMLHttpRequest for upload
    var xhr = new XMLHttpRequest();
    
    // Update progress
    xhr.upload.addEventListener('progress', function(e) {
      if (e.lengthComputable) {
        var percentComplete = (e.loaded / e.total) * 100;
        progressFill.style.width = percentComplete + '%';
        progressText.textContent = 'Загрузка: ' + Math.round(percentComplete) + '%';
      }
    });
    
    // Handle upload completion
    xhr.addEventListener('load', function() {
      console.log('Upload completed with status: ' + xhr.status);
      if (xhr.status === 200) {
        try {
          var response = JSON.parse(xhr.responseText);
          console.log('Upload response:', response);
          if (response.ok) {
            // Create a file item element
            var fileItem = document.createElement('div');
            fileItem.className = 'file-item';
            fileItem.innerHTML = '<span>' + response.file.original_name + ' (' + (response.file.size/1024).toFixed(1) + ' КБ)</span><span class="remove-btn" onclick="this.parentElement.remove()">✕</span>';
            
            // Add to the uploads container
            var uploadsContainer = document.getElementById('uploads-' + context);
            if (uploadsContainer) {
              uploadsContainer.appendChild(fileItem);
            } else {
              console.error('Uploads container not found for context: ' + context);
            }
            
            // Add to the uploaded files array
            uploadedFiles.push({
              filename: response.file.filename,
              original_name: response.file.original_name,
              mime: response.file.mime,
              size: response.file.size
            });
            
            // Update the hidden input
            if (uploadedFilesInput) {
              uploadedFilesInput.value = JSON.stringify(uploadedFiles);
              console.log('Updated uploaded files input:', uploadedFilesInput.value);
            }
          } else {
            alert('Ошибка загрузки файла: ' + response.error);
          }
        } catch (e) {
          console.error('Error parsing response:', e);
          alert('Ошибка обработки ответа сервера');
        }
      } else {
        alert('Ошибка загрузки файла: HTTP ' + xhr.status);
      }
      
      // Hide progress when all files are uploaded
      // In a real implementation, you'd track all uploads and hide when complete
      setTimeout(function() {
        progressContainer.style.display = 'none';
        progressFill.style.width = '0%';
        progressText.textContent = 'Загрузка: 0%';
      }, 1000);
    });
    
    // Handle upload errors
    xhr.addEventListener('error', function() {
      console.error('Upload error occurred');
      alert('Ошибка сети при загрузке файла');
      progressContainer.style.display = 'none';
    });
    
    // Send the request
    xhr.open('POST', 'upload.php', true);
    xhr.send(formData);
  }
}

// Make existing attachments sortable
document.addEventListener('DOMContentLoaded', function() {
  initializeSortableFiles();
});

function initializeSortableFiles() {
  var existingFilesContainer = document.getElementById('existing-files');
  if (existingFilesContainer) {
    // Simple drag and drop sorting
    var draggableItems = existingFilesContainer.querySelectorAll('.file-item');
    var dragSrcEl = null;
    
    draggableItems.forEach(function(item) {
      makeItemDraggable(item);
    });
  }
}

function makeItemDraggable(item) {
  item.setAttribute('draggable', true);
  
  item.addEventListener('dragstart', function(e) {
    e.dataTransfer.effectAllowed = 'move';
    dragSrcEl = this;
    this.classList.add('dragging');
  });
  
  item.addEventListener('dragover', function(e) {
    if (e.preventDefault) {
      e.preventDefault();
    }
    e.dataTransfer.dropEffect = 'move';
    return false;
  });
  
  item.addEventListener('dragenter', function(e) {
    this.classList.add('dragover');
  });
  
  item.addEventListener('dragleave', function(e) {
    this.classList.remove('dragover');
  });
  
  item.addEventListener('drop', function(e) {
    if (e.stopPropagation) {
      e.stopPropagation();
    }
    
    if (dragSrcEl != this) {
      // Swap the elements themselves, not just their content
      var temp = document.createElement('div');
      dragSrcEl.parentNode.insertBefore(temp, dragSrcEl);
      this.parentNode.insertBefore(dragSrcEl, this);
      temp.parentNode.insertBefore(this, temp);
      temp.parentNode.removeChild(temp);
      
      // Reinitialize drag and drop for the moved items
      makeItemDraggable(dragSrcEl);
      makeItemDraggable(this);
    }
    
    return false;
  });
  
  item.addEventListener('dragend', function(e) {
    this.classList.remove('dragging');
    this.classList.remove('dragover');
    
    // Remove dragover class from all items
    var container = document.getElementById('existing-files');
    if (container) {
      var items = container.querySelectorAll('.file-item');
      items.forEach(function(item) {
        item.classList.remove('dragover');
      });
    }
  });
}

// Function to add a new attachment to the existing attachments list
function addExistingAttachment(attachment) {
  var existingFilesContainer = document.getElementById('existing-files');
  if (!existingFilesContainer) {
    // Create the container if it doesn't exist
    var existingAttachmentsDiv = document.querySelector('.existing-attachments');
    if (!existingAttachmentsDiv) {
      var editForm = document.getElementById('edit-form-container');
      existingAttachmentsDiv = document.createElement('div');
      existingAttachmentsDiv.className = 'existing-attachments';
      existingAttachmentsDiv.innerHTML = '<font face="Verdana" size="-1"><b>Существующие вложения:</b></font>';
      editForm.appendChild(existingAttachmentsDiv);
    }
    
    existingFilesContainer = document.createElement('div');
    existingFilesContainer.className = 'sortable-files';
    existingFilesContainer.id = 'existing-files';
    existingAttachmentsDiv.appendChild(existingFilesContainer);
  }
  
  // Create a file item element
  var fileItem = document.createElement('div');
  fileItem.className = 'file-item';
  fileItem.setAttribute('data-id', attachment.id);
  fileItem.innerHTML = '<span>' + attachment.original_name + ' (' + (attachment.size/1024).toFixed(1) + ' КБ)</span><span class="remove-btn" onclick="removeAttachment(' + attachment.id + ')">✕</span>';
  
  // Add to the existing files container
  existingFilesContainer.appendChild(fileItem);
  
  // Make the new item draggable
  makeItemDraggable(fileItem);
}

// Function to edit a comment
function editComment(commentId) {
  // Create a modal for editing the comment
  var modal = document.createElement('div');
  modal.style.position = 'fixed';
  modal.style.left = '0';
  modal.style.top = '0';
  modal.style.width = '100%';
  modal.style.height = '100%';
  modal.style.backgroundColor = 'rgba(0,0,0,0.5)';
  modal.style.display = 'flex';
  modal.style.justifyContent = 'center';
  modal.style.alignItems = 'center';
  modal.style.zIndex = '10000';
  
  // Create modal content
  var modalContent = document.createElement('div');
  modalContent.style.backgroundColor = 'white';
  modalContent.style.padding = '20px';
  modalContent.style.borderRadius = '5px';
  modalContent.style.maxWidth = '500px';
  modalContent.style.width = '90%';
  modalContent.innerHTML = '<h3>Редактирование комментария</h3>' +
    '<p>Функция редактирования комментариев в панели администратора будет реализована в следующем обновлении.</p>' +
    '<p>Пока что вы можете:</p>' +
    '<ul>' +
    '  <li>Удалить комментарий и попросить пользователя добавить новый</li>' +
    '  <li>Отредактировать комментарий напрямую в базе данных</li>' +
    '</ul>' +
    '<button onclick="this.closest(\'div\').remove()" style="font-size: 12px; padding: 5px 10px; background-color: #007790; color: white; border: 1px solid #005a70; cursor: pointer; border-radius: 3px;">Закрыть</button>';
  
  modal.appendChild(modalContent);
  document.body.appendChild(modal);
}
</script>
<?php
}
?>
      </div>
    </div>
    
    <div class="footer">
      © <?php echo date('Y'); ?> Архив.ДуДу2
    </div>
  </div>
</div>
</body>
</html>